	function PLOT_PZ_S(Z, P, Wc, Ws, xmin, xmax, ymax)
	
	%	Plots the poles and zeros in the s-plane
	
	% Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2004-11-15
	% Modified by: 	 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	%========================================================
	ax = newplot;
	set(gca,'FontName', fn,'FontSize', fs);
	set(ax,'ylim',[-ymax ymax],'fontsize',fs,'linewidth', lw, 'fontname', fn);
	set(ax,'xlim',[xmin xmax]);
	daspect([1 1 1]);
	hold on
	% Plot axes	
	line([0 0],[-ymax, ymax]*0.9,'linewidth', lw);
	line([0.9*xmin 0.9*xmax], [0 0],'linewidth', lw);
	
	% Plot the circles
	alfa = linspace(pi/2, 3*pi/2, 200);
	plot(Ws*cos(alfa), Ws*sin(alfa),'-','linewidth', lw);
	plot(Wc*cos(alfa), Wc*sin(alfa),'-','linewidth', lw);
 
	% Check for multiple poles and zeros
	% First determine unique zeros and their multiplicity
	
	tol = 1.0e-14;
	if isempty(Z) ~= 1
		[unique_zeros, multiplicity_Z] = UNIQUE_ROOTS(Z);
		unique_zeros = unique_zeros+j*tol;	% Make real zeros sligthly complex
		plot(unique_zeros,'o','markersize', fs-2,'linewidth', 2)
		for a = 1:length(unique_zeros) 		% Plot multiplicity of the zeros
			position = unique_zeros(a)+ Wc*(0.03+i*0.10);
			if (multiplicity_Z(a) > 1)
				text(real(position), imag(position), int2str(multiplicity_Z(a)),'fontsize', fs-2)
			end
		end
	end
	[unique_poles, multiplicity_P] = UNIQUE_ROOTS(P);
	unique_poles = unique_poles+j*tol;
	plot(unique_poles, 'x','markersize', fs,'linewidth', 2);
	for a = 1:length(unique_poles) 		% Plot multiplicity of the poles
		position = unique_poles(a) + Wc*(-0.03+i*0.10);
		if (multiplicity_P(a) > 1)
			text(real(position), imag(position), int2str(multiplicity_P(a)),'fontsize', fs-2)
		end
	end
	% Check for zeros at infinity and cusality
	Zinf = length(P) - length(Z);
	if Zinf < 0 
		disp('WARNING  Noncausal transfer function');
	end
	if (Zinf >= 1)
		if Zinf == 1
			text(xmin, ymax-0.05, [' 1 zero at \infty'], 'FontName', fn, 'fontsize', fs, 'VerticalAlignment', 'top', 'HorizontalAlignment', 'left')
		else
			text(xmin, ymax-0.05, [' ', int2str(Zinf), ' zeros at \infty'], 'FontName', fn, 'fontsize', fs, 'VerticalAlignment', 'top', 'HorizontalAlignment', 'left')
		end
	end
	grid on;
	box on;
